/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.VWExpressionTextField;
import filenet.vw.toolkit.design.property.event.IVWExpressionTextFieldListener;
import filenet.vw.toolkit.design.property.event.IVWMapChangedListener;
import filenet.vw.toolkit.design.property.event.VWExpressionTextFieldEvent;
import filenet.vw.toolkit.design.property.event.VWMapChangedEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWMapListCellRenderer;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.VWInstruction;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.table.VWQuickSort;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class VWBeginTimerParamPanel
extends JPanel
implements ActionListener,
IVWMapChangedListener,
IVWExpressionTextFieldListener {
    private VWToolbarBorder m_timerNameBorder = null;
    private VWExpressionTextField m_timerNameTextField = null;
    private VWToolbarBorder m_expirationBorder = null;
    private VWExpressionTextField m_expirationTextField = null;
    private VWToolbarBorder m_submapBorder = null;
    private JComboBox m_submapComboBox = null;
    private JButton m_goToButton = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWInstructionDefinition m_instructionDef = null;

    public void init(VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.setLayout(new GridBagLayout());
        this.initTimerControls();
        this.m_authPropertyData.getMapChangeEventNotifier().addMapChangedListener(this);
    }

    public void setInstructionDefinition(VWInstructionDefinition instructionDef) {
        this.m_instructionDef = instructionDef;
        this.initMapComboBox();
        this.m_timerNameTextField.removeExpressionTextFieldListener(this);
        this.m_expirationTextField.removeExpressionTextFieldListener(this);
        this.m_submapComboBox.removeActionListener(this);
        String name = VWInstruction.BeginTimerInstructionGetName(this.m_instructionDef);
        String expirationTime = VWInstruction.BeginTimerInstructionGetExpirationTime(this.m_instructionDef);
        String submapName = VWInstruction.BeginTimerInstructionGetSubmapName(this.m_instructionDef);
        this.m_timerNameTextField.setText(name);
        this.m_expirationTextField.setText(expirationTime);
        this.m_submapComboBox.setSelectedItem(submapName);
        this.m_timerNameTextField.addExpressionTextFieldListener(this);
        this.m_expirationTextField.addExpressionTextFieldListener(this);
        this.m_submapComboBox.addActionListener(this);
    }

    public void actionPerformed(ActionEvent event) {
        String submapName = null;
        try {
            if (event.getSource().equals(this.m_submapComboBox)) {
                this.m_goToButton.setEnabled(false);
                submapName = this.m_submapComboBox.getSelectedItem().toString();
                if (VWStringUtils.compare(submapName, VWResource.s_noneItemStr) != 0) {
                    boolean bFound = false;
                    if (this.m_authPropertyData.getMapCache().isMapExist(submapName, true)) {
                        bFound = true;
                    }
                    if (bFound) {
                        this.m_goToButton.setEnabled(true);
                    }
                } else {
                    submapName = "";
                }
                VWInstruction.BeginTimerInstructionSetSubmapName(this.m_instructionDef, submapName);
                this.m_authPropertyData.setDirty();
            } else if (event.getSource().equals(this.m_goToButton)) {
                this.performGotoAction();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void mapChanged(VWMapChangedEvent event) {
        switch (event.getID()) {
            case 516: 
            case 517: 
            case 519: {
                this.initMapComboBox();
            }
        }
    }

    public void textUpdated(VWExpressionTextFieldEvent event) {
        Object src = event.getSource();
        if (src == this.m_expirationTextField) {
            this.updateExpirationTime();
        } else if (src == this.m_timerNameTextField) {
            this.updateTimerName();
        }
    }

    private void initTimerControls() {
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.anchor = 23;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 0, 0, 0);
        this.m_timerNameBorder = new VWToolbarBorder(VWResource.s_timerNameExpressionStr);
        this.add((Component)this.m_timerNameBorder, gbCons);
        JPanel clientPanel = this.m_timerNameBorder.getClientPanel();
        clientPanel.setLayout(new GridLayout());
        this.m_timerNameTextField = new VWExpressionTextField(this.m_authPropertyData.getMainContainer(), (IVWPropertyData)this.m_authPropertyData);
        this.m_timerNameTextField.addExpressionTextFieldListener(this);
        clientPanel.add(this.m_timerNameTextField);
        ++gbCons.gridy;
        this.m_expirationBorder = new VWToolbarBorder(VWResource.s_expirationTimeStr);
        this.add((Component)this.m_expirationBorder, gbCons);
        JPanel expirationPanel = this.m_expirationBorder.getClientPanel();
        expirationPanel.setLayout(new GridLayout());
        this.m_expirationTextField = new VWExpressionTextField(this.m_authPropertyData.getMainContainer(), (IVWPropertyData)this.m_authPropertyData);
        this.m_expirationTextField.addExpressionTextFieldListener(this);
        expirationPanel.add(this.m_expirationTextField);
        ++gbCons.gridy;
        gbCons.weighty = 1.0;
        this.m_submapBorder = new VWToolbarBorder(VWResource.s_mapStr, 0);
        this.add((Component)this.m_submapBorder, gbCons);
        JPanel submapPanel = this.m_submapBorder.getClientPanel();
        submapPanel.setLayout(new BorderLayout());
        this.m_submapComboBox = new JComboBox();
        this.m_submapComboBox.setRenderer(new VWMapListCellRenderer(this.m_authPropertyData));
        this.m_submapComboBox.addActionListener(this);
        submapPanel.add((Component)this.m_submapComboBox, "Center");
        this.m_goToButton = VWImageLoader.createIconButton("goto.gif", VWResource.s_gotoSubmapStr);
        this.m_goToButton.setName("m_goToButton_VWMapSelectionPanel");
        this.m_goToButton.setEnabled(false);
        this.m_goToButton.addActionListener(this);
        submapPanel.add((Component)this.m_goToButton, "After");
    }

    private void performGotoAction() {
        try {
            String mapName = (String)this.m_submapComboBox.getSelectedItem();
            this.m_authPropertyData.getToolbarActionNotifier().notifyToolbarAction(this, 503, mapName);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateTimerName() {
        try {
            String timerName = this.m_timerNameTextField.getText();
            VWInstruction.BeginTimerInstructionSetName(this.m_instructionDef, timerName);
            this.m_authPropertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateExpirationTime() {
        try {
            String time = this.m_expirationTextField.getText();
            VWInstruction.BeginTimerInstructionSetExpirationTime(this.m_instructionDef, time);
            this.m_authPropertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initMapComboBox() {
        Object[] mapNames = null;
        Vector<Object> mapNamesVec = new Vector<Object>();
        this.m_submapComboBox.removeActionListener(this);
        try {
            if (this.m_authPropertyData != null) {
                Object mapName;
                int i;
                this.m_submapComboBox.removeAllItems();
                this.m_submapComboBox.addItem(VWResource.s_noneItemStr);
                this.m_submapComboBox.addItem("Workflow");
                this.m_submapComboBox.addItem("Malfunction");
                this.m_submapComboBox.addItem("Terminate");
                VWMapDefinition[] mapDefs = this.m_authPropertyData.getMapCache().getMapDefinitions();
                if (mapDefs != null) {
                    int len = mapDefs.length;
                    for (i = 0; i < len; ++i) {
                        mapName = mapDefs[i].getName();
                        if (VWStringUtils.compare((String)mapName, "Workflow") == 0 || VWStringUtils.compare((String)mapName, "Malfunction") == 0 || VWStringUtils.compare((String)mapName, "Terminate") == 0) continue;
                        mapNamesVec.addElement(mapName);
                    }
                    mapNames = new String[mapNamesVec.size()];
                    mapNamesVec.copyInto(mapNames);
                }
                if (mapNames != null && mapNames.length > 0) {
                    VWQuickSort sortMap = new VWQuickSort(mapNames, 0);
                    sortMap.sort(0, mapNames.length);
                    for (i = 0; i < mapNames.length; ++i) {
                        mapName = mapNames[i];
                        if (VWStringUtils.compareIgnoreCase((String)mapName, "") == 0) continue;
                        this.m_submapComboBox.addItem(mapName);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_submapComboBox.addActionListener(this);
    }
}

